/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;

public class ObjectDumper {
    private static final String nullMsg = "<null>\n";
    private static final String maxNestMsg = "<max nesting level reached>\n";
    private static final String objExpandMsg = "<object expansion disabled>\n";
    private static final String arrayExpandMsg = "<array expansion disabled>\n";
    private static final String inaccessibleMsg = "<inaccessible>\n";
    private static final boolean DEBUG = true;
    private static final String TRACE_MASKT = "XFRMOD T";
    private static final String TRACE_MASKF = "XFRMOD F";
    private static final String TRACE_MASKD = "XFRMOD D";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public String dumpObject(Object dumpObject, ObjectDumperAttributes attributes) {
        Trace.trace(TRACE_MASKT, "-> dumpObject(dumpObject,attributes=" + attributes + ")");
        String result = "";
        if (attributes == null) {
            attributes = new ObjectDumperAttributes();
        }
        result = this.dumpObject(dumpObject, 0, 1, attributes, true);
        result = result.substring(0, result.length() - 1);
        Trace.trace(TRACE_MASKT, "<- dumpObject()");
        return result;
    }

    public String dumpObject(Object dumpObject) {
        return this.dumpObject(dumpObject, null);
    }

    private String dumpObject(Object dumpObject, int indent, int level, ObjectDumperAttributes attributes, boolean printClassName) {
        Trace.trace(TRACE_MASKF, "-> dumpObject(dumpObject,indent=" + indent + ",level=" + level + ",attributes,printClassName=" + printClassName + ")");
        StringBuffer result = new StringBuffer();
        Trace.trace(TRACE_MASKF, "dumpObject class=" + (dumpObject == null ? "null" : dumpObject.getClass().getName()));
        if (dumpObject == null) {
            result.append(nullMsg);
        } else if (dumpObject instanceof String) {
            if (indent == 0) {
                result.append(this.formatStringValue((String)dumpObject, 0)).append('\n');
            } else {
                result.append(this.formatStringValue((String)dumpObject, indent + 10)).append('\n');
            }
        } else if (dumpObject instanceof char[]) {
            String value = new String((char[])dumpObject);
            if (indent == 0) {
                result.append(this.formatStringValue(value, 0)).append('\n');
            } else {
                result.append(this.formatStringValue(value, indent + 8)).append('\n');
            }
        } else if (dumpObject instanceof byte[]) {
            String value = HexString.toHex((byte[])dumpObject, 4, 16, true);
            if (indent == 0) {
                result.append(this.formatStringValue(value, 0)).append('\n');
            } else {
                result.append(this.formatStringValue(value, indent + 8)).append('\n');
            }
        } else if (dumpObject instanceof Number) {
            result.append(this.formatNumberValue((Number)dumpObject)).append('\n');
        } else if (dumpObject instanceof Boolean) {
            result.append(this.formatBooleanValue((Boolean)dumpObject)).append('\n');
        } else if (dumpObject instanceof Character) {
            result.append(this.formatCharValue(((Character)dumpObject).charValue())).append('\n');
        } else if (level > attributes.getMaxLevel()) {
            result.append(maxNestMsg);
        } else if (indent > 0 && !attributes.isExpandObjects()) {
            result.append(objExpandMsg);
        } else {
            Class<?> dumpObjectClass = dumpObject.getClass();
            if (printClassName) {
                result.append(dumpObjectClass.getName());
            }
            result.append('\n');
            result.append(this.dumpFields(dumpObject, dumpObjectClass, indent, level, attributes));
            if (attributes.isDumpSuperclasses()) {
                while (dumpObjectClass != (class$java$lang$Object == null ? ObjectDumper.class$("java.lang.Object") : class$java$lang$Object)) {
                    if ((dumpObjectClass = dumpObjectClass.getSuperclass()) == (class$java$lang$Object == null ? ObjectDumper.class$("java.lang.Object") : class$java$lang$Object)) continue;
                    result.append(this.dumpFields(dumpObject, dumpObjectClass, indent, level, attributes));
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- dumpObject()");
        return result.toString();
    }

    String dumpFields(Object object, Class objectClass, int indent, int level, ObjectDumperAttributes attributes) {
        Trace.trace(TRACE_MASKF, "-> dumpFields(object,indent=" + indent + ",level=" + level + ",attributes)");
        StringBuffer result = new StringBuffer();
        String indentString = this.pad(indent);
        Field[] fields = objectClass.getDeclaredFields();
        int fieldsCnt = fields.length;
        Trace.trace(TRACE_MASKF, "fieldsCnt=" + fieldsCnt);
        int ix = fieldsCnt - 1;
        while (ix >= 0) {
            Field field = fields[ix];
            int modifier = field.getModifiers();
            if (!(!attributes.isDumpPublic() && Modifier.isPublic(modifier) || !attributes.isDumpProtected() && Modifier.isProtected(modifier) || !attributes.isDumpPrivate() && Modifier.isPrivate(modifier) || !attributes.isDumpStatic() && Modifier.isStatic(modifier) || !attributes.isDumpFinal() && Modifier.isFinal(modifier) || !attributes.isDumpTransient() && Modifier.isTransient(modifier) || !attributes.isDumpVolatile() && Modifier.isVolatile(modifier) || !attributes.isDumpPackagePrivate() && !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier))) {
                String modifierString = this.formatModifiers(modifier);
                result.append(modifierString).append(indentString);
                Class<?> type = field.getType();
                StringBuffer dimension = new StringBuffer();
                if (type == (class$java$lang$String == null ? ObjectDumper.class$("java.lang.String") : class$java$lang$String)) {
                    result.append("String");
                } else if (type.isArray()) {
                    Class<?> componentType = type;
                    while (componentType.isArray()) {
                        dimension.append("[]");
                        componentType = componentType.getComponentType();
                        if (componentType.isArray()) continue;
                        if (componentType == (class$java$lang$String == null ? ObjectDumper.class$("java.lang.String") : class$java$lang$String)) {
                            result.append("String");
                            continue;
                        }
                        result.append(componentType.getName());
                    }
                } else {
                    result.append(type.getName());
                }
                result.append(' ');
                result.append(field.getName()).append(dimension).append(' ');
                try {
                    try {
                        field.setAccessible(true);
                    }
                    catch (SecurityException exc) {
                        // empty catch block
                    }
                    Object fieldValue = field.get(object);
                    if (type.isArray()) {
                        result.append(this.dumpArray(fieldValue, indent, level + 1, attributes));
                    } else {
                        result.append(this.dumpObject(fieldValue, indent + 2, level + 1, attributes, false));
                    }
                }
                catch (IllegalAccessException exc) {
                    result.append(inaccessibleMsg);
                }
            }
            --ix;
        }
        Trace.trace(TRACE_MASKF, "<- dumpFields");
        return result.toString();
    }

    String dumpArray(Object array, int indent, int level, ObjectDumperAttributes attributes) {
        Trace.trace(TRACE_MASKF, "-> dumpArray(array,indent=" + indent + ",level=" + level + ",attributes)");
        StringBuffer result = new StringBuffer();
        if (array == null) {
            result.append(nullMsg);
        } else if (level > attributes.getMaxLevel()) {
            result.append(' ').append(maxNestMsg);
        } else {
            ObjectDumperAttributes attributes2 = new ObjectDumperAttributes(attributes.maxLevel, (short)(attributes.attribs | 1));
            int size = Array.getLength(array);
            indent += 2;
            if (!attributes.isExpandArrays()) {
                result.append(arrayExpandMsg);
            } else if (array instanceof char[] || array instanceof byte[]) {
                result.append(this.dumpObject(array, indent, level, attributes2, false));
            } else {
                result.append('\n');
                String indentString = this.pad(indent + 8);
                int ix = 0;
                while (ix < size) {
                    result.append(indentString).append('[').append(ix).append("] ");
                    Object element = Array.get(array, ix);
                    if (element.getClass().isArray()) {
                        result.append(this.dumpArray(element, indent + 2, level + 1, attributes));
                    } else {
                        result.append(this.dumpObject(element, indent + 2, level, attributes, true));
                    }
                    ++ix;
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- dumpArray()");
        return result.toString();
    }

    String formatModifiers(int modifiers) {
        StringBuffer result = new StringBuffer();
        if (Modifier.isPublic(modifiers)) {
            result.append("Pub");
        } else if (Modifier.isPrivate(modifiers)) {
            result.append("Prv");
        } else if (Modifier.isProtected(modifiers)) {
            result.append("Pro");
        }
        if (Modifier.isFinal(modifiers)) {
            result.append('F');
        }
        if (Modifier.isStatic(modifiers)) {
            result.append('S');
        }
        if (Modifier.isTransient(modifiers)) {
            result.append('T');
        }
        if (Modifier.isVolatile(modifiers)) {
            result.append('V');
        }
        int size = result.length();
        int ix = 0;
        while (ix < 8 - size) {
            result.append(' ');
            ++ix;
        }
        return result.toString();
    }

    private String formatStringValue(String value, int indent) {
        int ix = value.indexOf(10);
        if (ix < 0) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        String indentString = this.pad(indent);
        if (indent > 0) {
            result.append('\n');
        }
        while (ix >= 0) {
            result.append(indentString).append(value.substring(0, ix + 1));
            value = value.substring(ix + 1);
            ix = value.indexOf(10);
        }
        result.append(indentString).append(value);
        return result.toString();
    }

    private String formatBooleanValue(boolean value) {
        return value ? "true" : "false";
    }

    private String formatCharValue(char value) {
        StringBuffer result = new StringBuffer();
        if (value >= ' ' && value <= '~') {
            result.append('\'').append(value).append("' ");
        }
        result.append("0x").append(HexString.toHex((short)value, true));
        return result.toString();
    }

    private String formatNumberValue(Number value) {
        StringBuffer result = new StringBuffer(value.toString());
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            result.append(" 0x").append(HexString.toHex(value, true));
        }
        return result.toString();
    }

    private String pad(int size) {
        StringBuffer result = new StringBuffer();
        int ix = 0;
        while (ix < size) {
            result.append(' ');
            ++ix;
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

